# Code Studio Contribution Guide

This page contains guidelines for contributing to the Code Studio packages. Please review these guidelines before submitting any pull requests to the package.

## Which Branch?

**ALL** bug fixes should be made to the branch which they belong.

## Pull Requests

The pull request process differs for new features and bugs. Before sending a pull request for a new feature, you should first create an issue with `[Proposal]` in the title. The proposal should describe the new feature, as well as implementation ideas. The proposal will then be reviewed and either approved or denied. Once a proposal is approved, a pull request may be created implementing the new feature. Pull requests which do not follow this guideline will be closed immediately.

Pull requests for bugs may be sent without creating any proposal issue. If you believe that you know of a solution for a bug that has been filed, please leave a comment detailing your proposed fix.

### Feature Requests

If you have an idea for a new feature you would like to see added to the package, you may create an issue with `[Request]` in the title. The feature request will then be reviewed by a core contributor.

## Coding Guidelines

Code Studio follows the [PSR-1](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-1-basic-coding-standard.md) and [PSR-4](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-4-autoloader.md) and laravel coding standards.
